% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aco.cores.R
\name{phi.calculate}
\alias{phi.calculate}
\title{Update pheromone levels for each decision node}
\usage{
phi.calculate(
  r,
  search.space = "ivbase",
  fitness_history = NULL,
  nodeslst.hist = NULL,
  Q = 1,
  alpha = 1,
  rho = 0.5,
  diff_tol = 1,
  phi0 = 2,
  phi_min = 1,
  phi_max = Inf
)
}
\arguments{
\item{r}{Integer. Current optimization round.}

\item{search.space}{Character, one of "ivbase" or "oralbase".
Default is "ivbase".}

\item{fitness_history}{Data frame. History of ants' fitness values and decision
variable selections across rounds.}

\item{nodeslst.hist}{Data frame. History of node-level pheromone values
across previous rounds.}

\item{Q}{A positive numeric value. Pheromone scaling constant controlling the
amount of pheromone deposited by high-quality solutions during each
iteration. Defaults to 1.}

\item{alpha}{A non-negative numeric value. Exponent controlling the influence
of pheromone values on the probability of selecting a component during
solution construction. Defaults to 1.}

\item{rho}{Numeric in (0, 1). Pheromone evaporation rate. Higher values
increase evaporation, encouraging exploration. Defaults to 0.5.}

\item{diff_tol}{Numeric. Tolerance threshold controlling when differences
in fitness values are treated as meaningful during pheromone updates.
Defaults to 1.}

\item{phi0}{A non-negative numeric value. Initial pheromone value assigned
to all nodes at the start of the search. Defaults to 2.}

\item{phi_min}{A non-negative numeric value. Lower bound for pheromone values, preventing
premature convergence. Defaults to 1.}

\item{phi_max}{A non-negative numeric value. Upper bound for pheromone values, limiting
excessive reinforcement. Defaults to Inf.}
}
\value{
A data frame (node list) with updated \code{phi} and \code{delta_phi}
for each node.
}
\description{
Compute pheromone increments (\code{delta_phi}) for each node in the ant colony
optimization search tree and update the global pheromone levels (\code{phi})
based on the ants' paths in the current round.
}
\details{
The update proceeds as follows:
\itemize{
\item Initialize the node list for the given search space with \eqn{phi = 0}.
\item Subset the ants from the current round in \code{fitness_history}.
\item Compute rank-based weights so better-performing ants contribute more:
\deqn{\Delta \phi \propto 1 / \mathrm{rank}^{\alpha}.}
\item Extract the decision columns and attach the computed weights to form
a working table of ant paths and contributions.
\item Map local decision indices to global node numbers using \code{node.no}
and \code{local.edge.no} from the node list.
\item For each node, sum contributions from ants that selected the node to
obtain \eqn{\Delta \phi}, then update pheromone with evaporation:
\deqn{\phi_{\mathrm{new}} = (1 - \rho)\,\phi_{\mathrm{prev}} + \Delta \phi.}
\item Clamp updated \eqn{\phi} to be between \code{phi_min} and \code{phi_max}.
}
}
\examples{
# Define search space
search.space <- "ivbase"
# Example fitness_history from round 1
fitness_history <- data.frame(
  round   = rep(1, 8),
  mod.no  = 1:8,
  no.cmpt = c(1, 1, 2, 2, 3, 3, 2, 2),
  eta.km  = c(0, 0, 0, 0, 0, 0, 0, 0),
  eta.vc  = c(0, 0, 0, 0, 0, 0, 1, 1),
  eta.vp  = c(0, 0, 0, 0, 0, 0, 0, 1),
  eta.vp2 = c(0, 0, 0, 0, 0, 0, 0, 0),
  eta.q   = c(0, 0, 0, 0, 0, 0, 0, 0),
  eta.q2  = c(0, 0, 0, 0, 0, 0, 0, 0),
  mm      = c(0, 0, 0, 0, 0, 0, 1, 0),
  mcorr   = c(0, 0, 0, 0, 0, 0, 0, 0),
  rv      = c(1, 2, 1, 2, 1, 2, 1, 1),
  fitness = c(1243.874, 1200.762, 31249.876, 31202.200,
              51259.286, 51204.839, 61032.572, 41031.825),
  allrank = c(2, 1, 4, 3, 7, 6, 8, 5)
)

# Example node list history
nodeslst.hist <- initNodeList(
  search.space = search.space,
  phi0 = 2
)

 phi.calculate(
  r = 1,
  search.space = search.space,
  fitness_history = fitness_history,
  nodeslst.hist = nodeslst.hist
)

}
\seealso{
\link{initNodeList}, \link{rank_new}
}
\author{
Zhonghui Huang
}
