% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelGen.R
\name{omega_block}
\alias{omega_block}
\title{Generate omega block Code for nlmixr2 model}
\usage{
omega_block(param_list, mcorr, eta_table)
}
\arguments{
\item{param_list}{A character vector of parameter names requiring inter-individual
variability (IIV) terms.}

\item{mcorr}{Integer flag indicating covariance structure:
\itemize{
\item \code{0}: Generate independent variance terms only
\item \code{1}: Generate full block covariance structure
}}

\item{eta_table}{A data frame containing eta initialization values and correlation
coefficients. Must contain columns:
\itemize{
\item \code{Name}: Parameter names (format "eta.X" for variances, "cor.eta_X_Y" for correlations)
\item \code{init}: Initialization values for variance/covariance terms
}}
}
\value{
A character string containing nlmixr2 omega matrix specification code.
\itemize{
\item When \code{mcorr = 0}: Returns individual variance terms in formula syntax
\item When \code{mcorr = 1}: Returns covariance block structure in matrix syntax
}
}
\description{
Generates the code for the omega block matrix in nlmixr2 syntax,
supporting both independent variance terms and correlated covariance structures.
}
\examples{
# Example eta table structure
eta_table <- initialize_param_table()

# Generate independent terms
omega_block(c("eta.cl", "eta.vc"), mcorr = 0, eta_table)

# Generate covariance block
omega_block(c("eta.cl", "eta.vc"), mcorr = 1, eta_table)

}
\author{
Zhonghui Huang
}
