% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SkaterEDGE.R
\name{skater_edge_skating_speed}
\alias{skater_edge_skating_speed}
\title{Access the EDGE skating speed statistics for a skater, season, game type, and
category}
\usage{
skater_edge_skating_speed(
  player = 8478402,
  season = "now",
  game_type = "",
  category = "details"
)
}
\arguments{
\item{player}{integer ID (e.g., 8480039); see \code{\link[=players]{players()}} for reference}

\item{season}{integer in YYYYYYYY (e.g., 20242025); see
\code{\link[=skater_edge_seasons]{skater_edge_seasons()}} for reference}

\item{game_type}{integer in 1:3 (where 1 = pre-season, 2 = regular season, 3
= playoff/post-season) OR character of 'pre', 'regular', or
'playoff'/'post'; see \code{\link[=skater_edge_seasons]{skater_edge_seasons()}} for reference; most functions
will NOT support pre-season}

\item{category}{character of 'd'/'details' or 't'/'top'/'top speeds'}
}
\value{
list with four items (category = 'details') or data.frame with
one row per burst (category = 'top speeds')
}
\description{
\code{skater_edge_skating_speed()} retrieves the EDGE skating speed statistics for a skater, season, game type, and category as a nested \code{list} that separates summary and detail blocks for NHL EDGE style tracking outputs and relative-performance context.
}
\examples{
Martin_Necas_top_speeds_regular_20242025 <- skater_edge_skating_speed(
  player    = 8480039,
  season    = 20242025,
  game_type = 2,
  category  = 'T'
)
}
