% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivatives.R
\name{gradient}
\alias{gradient}
\title{Compute the gradient of a scalar-valued function}
\usage{
gradient(f, x)
}
\arguments{
\item{f}{A function taking a parameter vector (numeric or dual) and
returning a scalar. Parameters are accessed via \code{x[i]}.}

\item{x}{A numeric vector of parameter values.}
}
\value{
A numeric vector of length \code{p} containing the gradient.
}
\description{
Evaluates the gradient of \code{f} at \code{x} using forward-mode AD.
Equivalent to \code{D(f, x)} for scalar-valued \code{f}.
}
\details{
The function should use \code{x[1]}, \code{x[2]}, etc. to access
parameters. This is compatible with the standard R convention used by
\code{optim}.
}
\examples{
f <- function(x) -(x[1] - 3)^2 - (x[2] - 5)^2
gradient(f, c(1, 2))
}
