% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-math.R
\name{dual-math2}
\alias{dual-math2}
\alias{Math2,dualr-method}
\title{Math2 group generic for dual numbers}
\usage{
\S4method{Math2}{dualr}(x, digits)
}
\arguments{
\item{x}{A \code{dual} number.}

\item{digits}{Integer; number of digits for rounding.}
}
\value{
A \code{dual} with the rounded value and zero derivative.
}
\description{
Implements \code{round} and \code{signif} for dual numbers. These are
piecewise constant functions, so the derivative is zero almost everywhere.
}
\examples{
x <- dual_variable(3.14159)
value(round(x, 2))
deriv(round(x, 2))

}
