% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_reverse_hourglass_test.R
\name{reverse_hourglass_score}
\alias{reverse_hourglass_score}
\title{Reverse Hourglass Score Function}
\usage{
reverse_hourglass_score(txi, modules)
}
\arguments{
\item{txi}{Numeric vector of transcriptomic index values}

\item{modules}{A named list with elements 'early', 'mid', and 'late' containing
stage indices for each developmental module}
}
\value{
A numeric value representing the reverse hourglass score
}
\description{
Compute the reverse hourglass score by comparing mid developmental
stages to early and late stages.
}
\details{
The score is computed as the minimum of:
- D1: mean(mid) - mean(early)
- D2: mean(mid) - mean(late)

Higher scores indicate stronger reverse hourglass patterns (mid stages
dominated by younger genes).
# Compute reverse hourglass score
# modules <- list(early = 1:3, mid = 4:6, late = 7:9)
# score <- reverse_hourglass_score(txi_values, modules)
}
\keyword{internal}
