% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_automatic.R
\name{Separate_Multi_MVFMR}
\alias{Separate_Multi_MVFMR}
\title{Separate univariable functional MR estimation (internal)}
\usage{
Separate_Multi_MVFMR(
  Gmatrix1,
  Gmatrix2 = NULL,
  res1 = NA,
  res2 = NA,
  Yvector,
  IDmatch = NA,
  nPC1_selected = NA,
  max_nPC1 = NA,
  nPC2_selected = NA,
  max_nPC2 = NA,
  method = "gmm",
  basis = "eigenfunction",
  outcome = "continuous",
  bootstrap = FALSE,
  n_B = 10,
  improvement_threshold = 0.01,
  X1Ymodel = NA,
  X2Ymodel = NA,
  num_cores_set = NA,
  verbose = FALSE
)
}
\arguments{
\item{Gmatrix1}{Genetic instrument matrix for exposure 1 (N × J1)}

\item{Gmatrix2}{Genetic instrument matrix for exposure 2 (required if separate_G = TRUE)}

\item{res1}{FPCA result for exposure 1 (from fdapace)}

\item{res2}{FPCA result for exposure 2 (from fdapace)}

\item{Yvector}{Outcome vector (length N)}

\item{IDmatch}{Optional index vector to match rows of Gmatrix, Gmatrix2 (if used), and Yvector (default: 1:N)}

\item{nPC1_selected}{Fixed number of principal components to retain for exposure 1 (NA = select automatically)}

\item{max_nPC1}{Maximum number of principal components to consider for exposure 1 during selection}

\item{nPC2_selected}{Fixed number of principal components to retain for exposure 2 (NA = select automatically)}

\item{max_nPC2}{Maximum number of principal components to consider for exposure 2 during selection}

\item{method}{Estimation method: "gmm" (Generalized Method of Moments), "cf" (control function), or "cf-lasso" (control function with Lasso)}

\item{basis}{Basis type for functional representation: "eigenfunction" or "polynomial"}

\item{outcome}{Outcome type: "continuous" for numeric or "binary" for 0/1 outcomes}

\item{bootstrap}{Logical; whether to perform bootstrap inference for confidence intervals}

\item{n_B}{Number of bootstrap iterations (used only if bootstrap = TRUE)}

\item{improvement_threshold}{Minimum cross-validation improvement required to add an additional principal component}

\item{X1Ymodel}{Optional: true effect model for X1 on Y (simulation only)}

\item{X2Ymodel}{Optional: true effect model for X2 on Y (simulation only)}

\item{num_cores_set}{Number of CPU cores to use for parallel processing}

\item{verbose}{Print progress messages and diagnostics during computation}
}
\value{
List with separate estimation results for both exposures
}
\description{
Performs separate estimation of time-varying causal effects for each
exposure independently with automatic component selection.
}
\keyword{internal}
