% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provenance.R
\name{provenance_diff}
\alias{provenance_diff}
\title{Compare two provenance objects}
\usage{
provenance_diff(prov1, prov2)
}
\arguments{
\item{prov1}{First provenance list.}

\item{prov2}{Second provenance list.}
}
\value{
A \code{metasurvey_provenance_diff} list with detected differences.
}
\description{
Shows differences between two provenance records, useful for
comparing processing across survey editions.
}
\examples{
svy1 <- Survey$new(
  data = data.table::data.table(id = 1:5, w = rep(1, 5)),
  edition = "2023", type = "test",
  engine = "data.table", weight = add_weight(annual = "w")
)
svy2 <- Survey$new(
  data = data.table::data.table(id = 1:5, w = rep(2, 5)),
  edition = "2024", type = "test",
  engine = "data.table", weight = add_weight(annual = "w")
)
provenance_diff(provenance(svy1), provenance(svy2))

}
\seealso{
Other provenance: 
\code{\link{print.metasurvey_provenance}()},
\code{\link{print.metasurvey_provenance_diff}()},
\code{\link{provenance}()},
\code{\link{provenance_to_json}()}
}
\concept{provenance}
