% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F21.R
\name{F21}
\alias{F21}
\title{Shekel 5 Function (F21)}
\usage{
F21(x)
}
\arguments{
\item{x}{Numeric vector of length 4 (4-dimensional input).}
}
\value{
Numeric scalar representing the function value.
}
\description{
A multimodal test function from the Shekel family with 5 local minima.
Fixed dimension of 4.
}
\details{
\strong{Formula:}
\deqn{f(x) = -\sum_{i=1}^{5} \frac{1}{(x - a_i)^T(x - a_i) + c_i}}

where \eqn{a_i} are 4-dimensional vectors and \eqn{c_i} are scalars.

\strong{Global minimum:} \eqn{f(4, 4, 4, 4) \approx -10.1532}

\strong{Characteristics:}
\itemize{
  \item Type: Multimodal
  \item Separable: No
  \item Differentiable: Yes
  \item Fixed dimension: 4
  \item Number of local minima: 5
  \item Default bounds: \eqn{[0, 10]^4}
}

The Shekel functions are parameterized by the number of terms m (here m=5).
As m increases, the function becomes more challenging.
}
\examples{
F21(c(4, 4, 4, 4))  # Returns approximately -10.15 (near global minimum)
F21(c(0, 0, 0, 0))  # Returns a value close to 0

}
\seealso{
\code{\link{test-functions}} for an overview of all test functions,
\code{\link{get_function_details}} to retrieve function parameters,
\code{\link{F22}} for Shekel 7, \code{\link{F23}} for Shekel 10.
}
