% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp-get-spain.R
\encoding{UTF-8}
\name{esp_get_spain}
\alias{esp_get_spain}
\alias{esp_get_country}
\title{Boundaries of Spain - GISCO}
\source{
\url{https://gisco-services.ec.europa.eu/distribution/v2/}.

Copyright:
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/administrative-units}.
}
\usage{
esp_get_spain(moveCAN = TRUE, ...)
}
\arguments{
\item{moveCAN}{A logical \code{TRUE/FALSE} or a vector of coordinates
\code{c(lat, lon)}. It places the Canary Islands close to Spain's mainland.
Initial position can be adjusted using the vector of coordinates. See
\strong{Displacing the Canary Islands} in \code{\link[=esp_move_can]{esp_move_can()}}.}

\item{...}{
  Arguments passed on to \code{\link[=esp_get_nuts]{esp_get_nuts}}
  \describe{
    \item{\code{year}}{year character string or number. Release year of the file. See
\code{\link[giscoR:gisco_get_nuts]{giscoR::gisco_get_nuts()}} for valid values.}
    \item{\code{epsg}}{character string or number. Projection of the map: 4-digit
\href{https://epsg.io/}{EPSG code}. One of:
\itemize{
\item \code{"4258"}: \href{https://epsg.io/4258}{ETRS89}
\item \code{"4326"}: \href{https://epsg.io/4326}{WGS84}.
\item \code{"3035"}: \href{https://epsg.io/3035}{ETRS89 / ETRS-LAEA}.
\item \code{"3857"}: \href{https://epsg.io/3857}{Pseudo-Mercator}.
}}
    \item{\code{cache}}{logical. Whether to do caching. Default is \code{TRUE}. See
\strong{Caching strategies} section in \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.}
    \item{\code{update_cache}}{logical. Should the cached file be refreshed? Default
is \code{FALSE}. When set to \code{TRUE}, it will force a new download.}
    \item{\code{cache_dir}}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.}
    \item{\code{ext}}{character. Extension of the file (default \code{"gpkg"}). See
\code{\link[giscoR:gisco_get_nuts]{giscoR::gisco_get_nuts()}}.}
    \item{\code{verbose}}{logical. If \code{TRUE} displays informational messages.}
    \item{\code{resolution}}{character string or number. Resolution of the geospatial
data. One of:
\itemize{
\item \code{"60"}: 1:60 million.
\item \code{"20"}: 1:20 million.
\item \code{"10"}: 1:10 million.
\item \code{"03"}: 1:3 million.
\item \code{"01"}: 1:1 million.
}}
  }}
}
\value{
A \code{\link[sf:sf]{sf}} \code{POLYGON} object.
}
\description{
Returns the boundaries of Spain as a single \code{\link[sf:sf]{sf}} \code{POLYGON} at a
specified scale.
}
\details{
Dataset derived from NUTS data provided by GISCO. Check \code{\link[=esp_get_nuts]{esp_get_nuts()}} for
details.
}
\section{Note}{

Please check the download and usage provisions on \code{\link[giscoR:gisco_attributions]{gisco_attributions()}}.

}

\examples{
\dontshow{if (esp_check_access()) withAutoprint(\{ # examplesIf}
\donttest{
original_can <- esp_get_spain(moveCAN = FALSE)

# One row only
original_can


library(ggplot2)

ggplot(original_can) +
  geom_sf(fill = "grey70")

# Less resolution
moved_can <- esp_get_spain(moveCAN = TRUE, resolution = 20)

ggplot(moved_can) +
  geom_sf(fill = "grey70")
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other datasets representing political borders:
\code{\link{esp_get_capimun}()},
\code{\link{esp_get_ccaa}()},
\code{\link{esp_get_ccaa_siane}()},
\code{\link{esp_get_comarca}()},
\code{\link{esp_get_countries_siane}()},
\code{\link{esp_get_gridmap}},
\code{\link{esp_get_munic}()},
\code{\link{esp_get_munic_siane}()},
\code{\link{esp_get_nuts}()},
\code{\link{esp_get_prov}()},
\code{\link{esp_get_prov_siane}()},
\code{\link{esp_get_simpl}},
\code{\link{esp_get_spain_siane}()},
\code{\link{esp_siane_bulk_download}()}

Other nuts: 
\code{\link{esp_get_nuts}()}

Datasets provided by GISCO:
\code{\link{esp_get_ccaa}()},
\code{\link{esp_get_munic}()},
\code{\link{esp_get_nuts}()},
\code{\link{esp_get_prov}()}
}
\concept{gisco}
\concept{nuts}
\concept{political}
