% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addProviderEspTiles.R
\encoding{UTF-8}
\name{addProviderEspTiles}
\alias{addProviderEspTiles}
\title{Add a tile layer from Spanish public administrations to a \CRANpkg{leaflet}
map}
\source{
\url{https://dieghernan.github.io/leaflet-providersESP/} leaflet plugin,
\strong{v1.3.3}.
}
\usage{
addProviderEspTiles(
  map,
  provider,
  layerId = NULL,
  group = NULL,
  options = leaflet::providerTileOptions()
)
}
\arguments{
\item{map}{the map to add the tile layer to}

\item{provider}{the name of the provider, see \link{esp_tiles_providers} or
\url{https://dieghernan.github.io/leaflet-providersESP/preview/}.}

\item{layerId}{the layer id to assign}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet:clearGroup]{clearGroup()}} and \code{\link[leaflet:addLayersControl]{addLayersControl()}} purposes). Human-friendly
group names are permitted--they need not be short, identifier-style names.}

\item{options}{tile options}
}
\value{
modified map object
}
\description{
Add a tile layer from Spanish public administrations to a \CRANpkg{leaflet}
map
}
\examples{
library(leaflet)
leafmap <- leaflet(width = "100\%", height = "60vh") |>
  setView(lat = 40.4166, lng = -3.7038400, zoom = 10) |>
  addTiles(group = "Default (OSM)") |>
  addProviderEspTiles(
    provider = "IDErioja.Claro",
    group = "IDErioja Claro"
  ) |>
  addProviderEspTiles(
    provider = "RedTransporte.Carreteras",
    group = "Carreteras"
  ) |>
  addLayersControl(
    baseGroups = c("IDErioja Claro", "Default (OSM)"),
    overlayGroups = "Carreteras",
    options = layersControlOptions(collapsed = FALSE)
  )

leafmap
}
\seealso{
\code{\link[leaflet:leaflet]{leaflet::leaflet()}}, \code{\link[leaflet:map-layers]{leaflet::addTiles()}}, \code{\link[leaflet:map-layers]{leaflet::addWMSTiles()}},
\link{esp_tiles_providers}.

Other functions for creating maps with images:
\code{\link{esp_get_tiles}()},
\code{\link{esp_make_provider}()}
}
\concept{images}
