% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_processor.R
\name{LayerProcessor}
\alias{LayerProcessor}
\title{Abstract Layer Processor Interface}
\description{
Abstract Layer Processor Interface

Abstract Layer Processor Interface
}
\details{
This is the abstract base class for all layer processors. It defines the
interface that all layer processors must implement.
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{layer_info}}{Information about the layer}

\item{\code{layer_info}}{Information about the layer}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LayerProcessor-new}{\code{LayerProcessor$new()}}
\item \href{#method-LayerProcessor-process}{\code{LayerProcessor$process()}}
\item \href{#method-LayerProcessor-extract_data}{\code{LayerProcessor$extract_data()}}
\item \href{#method-LayerProcessor-generate_selectors}{\code{LayerProcessor$generate_selectors()}}
\item \href{#method-LayerProcessor-needs_reordering}{\code{LayerProcessor$needs_reordering()}}
\item \href{#method-LayerProcessor-reorder_layer_data}{\code{LayerProcessor$reorder_layer_data()}}
\item \href{#method-LayerProcessor-get_layer_index}{\code{LayerProcessor$get_layer_index()}}
\item \href{#method-LayerProcessor-set_last_result}{\code{LayerProcessor$set_last_result()}}
\item \href{#method-LayerProcessor-get_last_result}{\code{LayerProcessor$get_last_result()}}
\item \href{#method-LayerProcessor-extract_layer_axes}{\code{LayerProcessor$extract_layer_axes()}}
\item \href{#method-LayerProcessor-apply_scale_mapping}{\code{LayerProcessor$apply_scale_mapping()}}
\item \href{#method-LayerProcessor-clone}{\code{LayerProcessor$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayerProcessor-new"></a>}}
\if{latex}{\out{\hypertarget{method-LayerProcessor-new}{}}}
\subsection{Method \code{new()}}{
Initialize the layer processor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayerProcessor$new(layer_info)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layer_info}}{Information about the layer}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayerProcessor-process"></a>}}
\if{latex}{\out{\hypertarget{method-LayerProcessor-process}{}}}
\subsection{Method \code{process()}}{
Process the layer (MUST be implemented by subclasses)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayerProcessor$process(
  plot,
  layout,
  built = NULL,
  gt = NULL,
  scale_mapping = NULL,
  grob_id = NULL,
  panel_ctx = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot}}{The ggplot2 object}

\item{\code{layout}}{Layout information}

\item{\code{built}}{Built plot data (optional)}

\item{\code{gt}}{Gtable object (optional)}

\item{\code{scale_mapping}}{Scale mapping for faceted plots (optional)}

\item{\code{grob_id}}{Grob ID for faceted plots (optional)}

\item{\code{panel_ctx}}{Panel context for panel-scoped selector generation (optional)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List with data and selectors
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayerProcessor-extract_data"></a>}}
\if{latex}{\out{\hypertarget{method-LayerProcessor-extract_data}{}}}
\subsection{Method \code{extract_data()}}{
Extract data from the layer (MUST be implemented by subclasses)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayerProcessor$extract_data(plot, built = NULL, scale_mapping = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot}}{The ggplot2 object}

\item{\code{built}}{Built plot data (optional)}

\item{\code{scale_mapping}}{Scale mapping for faceted plots (optional)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Extracted data
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayerProcessor-generate_selectors"></a>}}
\if{latex}{\out{\hypertarget{method-LayerProcessor-generate_selectors}{}}}
\subsection{Method \code{generate_selectors()}}{
Generate selectors for the layer (MUST be implemented by subclasses)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayerProcessor$generate_selectors(
  plot,
  gt = NULL,
  grob_id = NULL,
  panel_ctx = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot}}{The ggplot2 object}

\item{\code{gt}}{Gtable object (optional)}

\item{\code{grob_id}}{Grob ID for faceted plots (optional)}

\item{\code{panel_ctx}}{Panel context for panel-scoped selector generation (optional)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of selectors
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayerProcessor-needs_reordering"></a>}}
\if{latex}{\out{\hypertarget{method-LayerProcessor-needs_reordering}{}}}
\subsection{Method \code{needs_reordering()}}{
Check if this layer needs reordering (OPTIONAL - default: FALSE)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayerProcessor$needs_reordering()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Logical indicating if reordering is needed
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayerProcessor-reorder_layer_data"></a>}}
\if{latex}{\out{\hypertarget{method-LayerProcessor-reorder_layer_data}{}}}
\subsection{Method \code{reorder_layer_data()}}{
Reorder layer data (OPTIONAL - default: no-op)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayerProcessor$reorder_layer_data(data, plot)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{data.frame effective for this layer}

\item{\code{plot}}{full ggplot object (for mappings)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Reordered data
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayerProcessor-get_layer_index"></a>}}
\if{latex}{\out{\hypertarget{method-LayerProcessor-get_layer_index}{}}}
\subsection{Method \code{get_layer_index()}}{
Get layer index
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayerProcessor$get_layer_index()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Layer index
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayerProcessor-set_last_result"></a>}}
\if{latex}{\out{\hypertarget{method-LayerProcessor-set_last_result}{}}}
\subsection{Method \code{set_last_result()}}{
Store the last processed result (used by orchestrator)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayerProcessor$set_last_result(result)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{result}}{The result to store}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayerProcessor-get_last_result"></a>}}
\if{latex}{\out{\hypertarget{method-LayerProcessor-get_last_result}{}}}
\subsection{Method \code{get_last_result()}}{
Get the last processed result
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayerProcessor$get_last_result()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The last result
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayerProcessor-extract_layer_axes"></a>}}
\if{latex}{\out{\hypertarget{method-LayerProcessor-extract_layer_axes}{}}}
\subsection{Method \code{extract_layer_axes()}}{
Extract axes labels for this specific layer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayerProcessor$extract_layer_axes(plot, layout)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot}}{The ggplot object}

\item{\code{layout}}{Global layout with fallback axes}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List with x and y axis labels
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayerProcessor-apply_scale_mapping"></a>}}
\if{latex}{\out{\hypertarget{method-LayerProcessor-apply_scale_mapping}{}}}
\subsection{Method \code{apply_scale_mapping()}}{
Apply scale mapping to numeric values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayerProcessor$apply_scale_mapping(numeric_values, scale_mapping)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{numeric_values}}{Vector of numeric values}

\item{\code{scale_mapping}}{Scale mapping vector}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Mapped values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayerProcessor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LayerProcessor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayerProcessor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
