% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Math-Functions.R
\name{periodic_cov}
\alias{periodic_cov}
\title{Periodic covariance function}
\usage{
periodic_cov(d, range, phi = 1)
}
\arguments{
\item{d}{a numeric object containing pairwise distances between the centroids of the fields}

\item{range}{range (half-period of oscillations)}

\item{phi}{amplitude of the oscillations}
}
\value{
An object of the same type as d.
}
\description{
Periodic function used to compute the variance-covariance matrix of the fields of the landscape.
}
\details{
The periodic covariance is defined by \eqn{ exp(-2 * sin(d*pi/(2*range))^2 / phi^2) }. It is used to generate
highly fragmented or highly aggregated landscapes.
}
\examples{
periodic_cov(10, range = 5)
}
\seealso{
\link{multiN}
}
