% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dials-kindling.R
\name{dials-kindling}
\alias{dials-kindling}
\alias{n_hlayers}
\alias{hidden_neurons}
\alias{activations}
\alias{output_activation}
\alias{optimizer}
\alias{bias}
\alias{validation_split}
\alias{bidirectional}
\title{Tunable hyperparameters for \code{kindling} models}
\usage{
n_hlayers(range = c(1L, 2L), trans = NULL)

hidden_neurons(range = c(8L, 512L), disc_values = NULL, trans = NULL)

activations(
  values = c("relu", "relu6", "elu", "selu", "celu", "leaky_relu", "gelu", "softplus",
    "softshrink", "softsign", "tanhshrink", "hardtanh", "hardshrink", "hardswish",
    "hardsigmoid", "silu", "mish", "logsigmoid")
)

output_activation(
  values = c("relu", "elu", "selu", "softplus", "softmax", "log_softmax", "logsigmoid",
    "hardtanh", "hardsigmoid", "silu")
)

optimizer(values = c("adam", "sgd", "rmsprop", "adamw"))

bias(values = c(TRUE, FALSE))

validation_split(range = c(0, 0.5), trans = NULL)

bidirectional(values = c(TRUE, FALSE))
}
\arguments{
\item{range}{A two-element numeric vector with the default lower and upper bounds.}

\item{trans}{An optional transformation; \code{NULL} for none.}

\item{disc_values}{\code{NULL} (default) or an integer vector of specific possible disc_values
(e.g., \code{c(32L, 64L, 128L, 256L)}). When provided, tuning will be restricted to
these discrete values. The range is automatically derived from these values if not explicitly given.
The \code{trans} parameter would still be ignored by this parameter when supplied.}

\item{values}{Logical vector of possible values.}
}
\value{
Each function returns a \code{dials} parameter object:
\describe{
\item{\code{n_hlayers()}}{A quantitative parameter for the number of hidden layers}
\item{\code{hidden_neurons()}}{A quantitative parameter for hidden units per layer}
\item{\code{activations()}}{A qualitative parameter for activation function names}
\item{\code{output_activation()}}{A qualitative parameter for output activation}
\item{\code{optimizer()}}{A qualitative parameter for optimizer type}
\item{\code{bias()}}{A qualitative parameter for bias inclusion}
\item{\code{validation_split()}}{A quantitative parameter for validation proportion}
\item{\code{bidirectional()}}{A qualitative parameter for bidirectional RNN}
}
}
\description{
These parameters extend the \strong{dials} framework to support hyperparameter
tuning of neural networks built with the \code{{kindling}} package. They control
network architecture, activation functions, optimization, and training
behavior.
}
\section{Architecture Strategy}{

Since tidymodels tuning works with independent parameters, we use a simplified
approach where:
\itemize{
\item \code{hidden_neurons} specifies a single value that will be used for ALL layers
\item \code{activations} specifies a single activation that will be used for ALL layers
\item \code{n_hlayers} controls the depth
}

For more complex architectures with different neurons/activations per layer,
users should manually specify these after tuning or use custom tuning logic.
}

\section{Parameters}{


\describe{
\item{\code{n_hlayers}}{Number of hidden layers in the network.}
\item{\code{hidden_neurons}}{Number of units per hidden layer (applied to all layers).}
\item{\code{activation}}{Single activation function applied to all hidden layers.}
\item{\code{output_activation}}{Activation function for the output layer.}
\item{\code{optimizer}}{Optimizer algorithm.}
\item{\code{bias}}{Whether to include bias terms in layers.}
\item{\code{validation_split}}{Proportion of training data held out for validation.}
\item{\code{bidirectional}}{Whether RNN layers are bidirectional.}
}
}

\section{Number of Hidden Layers}{

Controls the depth of the network. When tuning, this will determine how many
layers are created, each with \code{hidden_neurons} units and \code{activations} function.
}

\section{Hidden Units per Layer}{

Specifies the number of units per hidden layer.
}

\section{Activation Function (Hidden Layers)}{

Activation functions for hidden layers.
}

\section{Output Activation Function}{

Activation function applied to the output layer. Values must correspond to
\verb{torch::nnf_*} functions.
}

\section{Optimizer Type}{

The optimization algorithm used during training.
}

\section{Include Bias Terms}{

Whether layers should include bias parameters.
}

\section{Validation Split Proportion}{

Fraction of the training data to use as a validation set during training.
}

\section{Bidirectional RNN}{

Whether recurrent layers should process sequences in both directions.
}

\examples{
\donttest{
library(dials)
library(tune)

# Create a tuning grid
grid = grid_regular(
    n_hlayers(range = c(1L, 4L)),
    hidden_neurons(range = c(32L, 256L)),
    activations(c('relu', 'elu', 'selu')),
    levels = c(4, 5, 3)
)

# Use in a model spec
mlp_spec = mlp_kindling(
    mode = "classification",
    hidden_neurons = tune(),
    activations = tune(),
    epochs = tune(),
    learn_rate = tune()
)
}

}
\keyword{internal}
