% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaccard.test.bootstrap.R
\name{jaccard.test.bootstrap}
\alias{jaccard.test.bootstrap}
\title{Compute p-value using the bootstrap procedure}
\usage{
jaccard.test.bootstrap(
  x,
  y,
  px = NULL,
  py = NULL,
  verbose = TRUE,
  fix = "x",
  B = 1000,
  seed = NULL
)
}
\arguments{
\item{x}{a binary vector (e.g., fingerprint)}

\item{y}{a binary vector (e.g., fingerprint)}

\item{px}{probability of successes in \code{x} (optional)}

\item{py}{probability of successes in \code{y} (optional)}

\item{verbose}{whether to print progress messages}

\item{fix}{whether to fix (i.e., not resample) \code{x} and/or \code{y}}

\item{B}{a total bootstrap iteration}

\item{seed}{a seed for a random number generator}
}
\value{
\code{jaccard.test.bootstrap} returns a list consisting of
\item{statistics}{centered Jaccard/Tanimoto similarity coefficient}
\item{pvalue}{p-value}
\item{expectation}{expectation}
}
\description{
Compute statistical significance of Jaccard/Tanimoto similarity coefficients.
}
\examples{
set.seed(1234)
x = rbinom(100,1,.5)
y = rbinom(100,1,.5)
jaccard.test.bootstrap(x,y,B=500)
}
