% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibreak.R
\name{i_break}
\alias{i_break}
\title{Create an iterator that can be told to stop.}
\usage{
i_break(iterable, finished, ...)
}
\arguments{
\item{iterable}{Iterable to iterate over.}

\item{finished}{Function that returns a logical value.  The iterator stops
when this function returns \code{FALSE}.}

\item{...}{Further arguments forwarded to \code{iteror}.}
}
\value{
an iteror which will stop when \code{finished()} is \code{TRUE}
}
\description{
Create an iterator that iterates over another iterator until a specified
function returns \code{FALSE}. This can be useful for breaking out of a
foreach loop, for example.
}
\details{
Originally from the \code{itertools} package.
}
\examples{

# See how high we can count in a tenth of a second
mkfinished <- function(time) {
  starttime <- proc.time()[3]
  function() proc.time()[3] > starttime + time
}
length(as.list(i_break(icount(), mkfinished(0.1))))

}
