% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipft.R
\name{ipfEstimate}
\alias{ipfEstimate}
\title{Estimates the location of the test observations}
\usage{
ipfEstimate(ipfmodel, test_fgp, test_pos = NULL)
}
\arguments{
\item{ipfmodel}{an ipfModel}

\item{test_fgp}{a matrix or a data frame containing the fingerprints of the test set}

\item{test_pos}{a matrix or a data frame containing the position of the test set fingerprints}
}
\value{
An S3 object of class ipfEstimation, with the following properties:
                location ->   a matrix with the predicted locations
                errors   ->   a numeric vector with the errors
                neighbors ->  a matrix with k columns and nrow(test) rows, with the
                              k most similar training observation for each test observation
                weights ->    a matrix with k columns and nrow(test) rows, with the weights
}
\description{
Estimates the location of the test observations
}
\examples{

    model <- ipfKnn(ipftrain[1:200, 1:168], ipftrain[1:200, 169:170])
    estimation <- ipfEstimate(model, ipftest[1:20, 1:168], ipftest[1:20, 169:170])

\dontrun{
    model <- ipfProbabilistic(ipftrain[, 1:168], ipftrain[, 169:170], k = 9, delta = 10)
    estimation <- ipfEstimate(model, ipftest[, 1:170], ipftest[, 169:170])
}
}
