% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idmc_get_data.R
\name{idmc_get_data}
\alias{idmc_get_data}
\title{Get data from the IDMC API}
\usage{
idmc_get_data(api_url = NULL)
}
\arguments{
\item{api_url}{URL to the IDMC API. If \code{NULL}, the default, searches for
the \code{IDMC_API} environment variable.}
}
\value{
Tibble of displacement data. Description of the data frame variables
are included in the documentation for the
\href{https://www.internal-displacement.org/database/api-documentation/}{IDMC IDU API}. # nolint
}
\description{
\code{idmc_get_data()} calls the IDMC API to retrieve displacement data. The data
is converted from JSON to a data frame, date columns converted to \code{Date}
types, and returned as a \link[dplyr:reexports]{dplyr::tibble}.
}
\examples{
\dontshow{if (!is.na(Sys.getenv("IDMC_API", unset = NA))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
idmc_get_data()
\dontshow{\}) # examplesIf}
}
