## ----fig.cap="Density of the Gumbel copula", fig.label="density", fig.width=8, fig.height=4, echo=FALSE, message=FALSE, warning=FALSE----
require(gumbel)         
x <- y <- seq(.1, .9, length = 30)
nrz <- length(x)
ncz <- length(y)
# Create a function interpolating colors in the range of specified colors
jet.colors <- colorRampPalette( c("white", "green", "yellow", "orange", "red") )
# Generate the desired number of colors from this palette
nbcol <- 100
color <- jet.colors(nbcol)

par(mfrow=1:2, mar=c(1,2,1,1))

z<-outer(x, y, dgumbel, alpha=1.5)
# Compute the z-value at the facet centres
zfacet <- z[-1, -1] + z[-1, -ncz] + z[-nrz, -1] + z[-nrz, -ncz]
# Recode facet z-values into color indices
facetcol <- cut(zfacet, nbcol)

persp(x, y, z, theta = 30, phi = 30, expand = 0.5, col = color[facetcol],
       ltheta = 100, shade = 0.25, ticktype = "detailed",
       xlab = "u", ylab = "v", zlab = "density", main=expression(alpha==1.5))
         
z <- outer(x, y, dgumbel, alpha=4)
zfacet <- z[-1, -1] + z[-1, -ncz] + z[-nrz, -1] + z[-nrz, -ncz]
# Recode facet z-values into color indices
facetcol <- cut(zfacet, nbcol)
                 
persp(x, y, z, theta = 30, phi = 30, expand = 0.5, col = color[facetcol],
       ltheta = 100, shade = 0.25, ticktype = "detailed",
       xlab = "u", ylab = "v", zlab = "density", main=expression(alpha==4))

