% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.beta.trt.R
\name{find.beta.trt}
\alias{find.beta.trt}
\title{Function to solve for treatment effect size given target power for two-sample tests.}
\usage{
find.beta.trt(power = 0.8, power.c, var)
}
\arguments{
\item{power}{Target power for the two-sided test, default is \code{0.8}.}

\item{power.c}{Positive numeric constant relating the mean of the test statistic under the alternative hypothesis to the treatment effect.}

\item{var}{Variance of the test statistic \eqn{Q} under the alternative hypothesis.}
}
\value{
A numeric value giving the treatment effect parameter.
}
\description{
Computes the treatment effect parameter \code{beta.trt} that achieves a specified power for a two-sided Wald-type
test under a normal approximation. The calculation assumes that the test statistic \eqn{Q} is asymptotically normal
with mean proportional to the treatment effect and variance \code{var}.
}
