% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grmtree-plot.R
\name{plot.grmtree}
\alias{plot.grmtree}
\title{Plot Method for GRM Tree Objects}
\usage{
\method{plot}{grmtree}(
  x,
  type = c("regions", "profile", "histogram"),
  what = c("item", "threshold", "discrimination"),
  tnex = 2L,
  drop_terminal = TRUE,
  spacing = 0.1,
  ...
)
}
\arguments{
\item{x}{A GRM tree object of class 'grmtree'.}

\item{type}{Type of terminal node plot to display:
\describe{
\item{"regions"}{Threshold regions plot (default)}
\item{"profile"}{Item parameter profile plot}
\item{"histogram"}{Histogram of factor scores with normal curve}
}}

\item{what}{Type of parameters to plot when \code{type = "profile"}:
\describe{
\item{"item"}{Both discrimination and threshold parameters (default)}
\item{"threshold"}{Only threshold parameters}
\item{"discrimination"}{Only discrimination parameters}
}}

\item{tnex}{Numeric scaling factor for terminal node extension (default: 2).}

\item{drop_terminal}{Logical indicating whether to drop terminal node IDs
(default: TRUE).}

\item{spacing}{Numeric value controlling spacing between elements (default:
0.1).}

\item{...}{Additional arguments passed to the terminal panel functions.}
}
\value{
Invisibly returns the GRM tree object. Primarily called for its side
effect of producing a plot.
}
\description{
Visualizes a GRM (Graded Response Model) tree with different types of
terminal node plots. This function extends \code{plot.modelparty} from the
partykit package with specialized visualizations for GRM trees.
}
\details{
The function provides three visualization types:
\itemize{
\item \strong{Regions plot}: Shows threshold parameters as colored regions, useful
for visualizing the difficulty parameters across items and nodes.
\item \strong{Profile plot}: Displays either item parameters (discrimination and
average thresholds), just thresholds, or just discrimination parameters as
line plots across items.
\item \strong{Histogram}: Shows the distribution of factor scores in each node
with an overlaid normal curve.
}
}
\examples{
\donttest{

library(grmtree)
library(hlt)
data("asti", package = "hlt")
asti$resp <- data.matrix(asti[, 1:4])

# Fit GRM tree with gender and group as partitioning variables
tree <- grmtree(resp ~ gender + group,
          data = asti,
          control = grmtree.control(minbucket = 30))

# Default regions plot
plot(tree)

# Profile plot showing item parameters
plot(tree, type = "profile")

# Profile plot showing only thresholds
plot(tree, type = "profile", what = "threshold")

# Histograms of factor scores
plot(tree, type = "histogram")
}

}
\seealso{
\code{\link[partykit]{plot.modelparty}} for the underlying plotting
infrastructure, \code{\link{grmtree}} for creating GRM tree objects,
\code{\link{plot.varimp}} creates a bar plot of variable importance scores
}
