% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6-ErrorList.R
\name{ErrorList}
\alias{ErrorList}
\title{ErrorList}
\description{
Handles all errors that occur during query validation. This object is returned from execute request function (\verb{ans <- [execute_request](query, schema)}) under the field 'error_list' (\code{ans$error_list}).
}
\section{Usage}{

\preformatted{answer <- execute_request(my_request, my_schema)
answer$error_list
}
}

\section{Initialize}{

\describe{
\item{verbose}{boolean that determines if errors will be printed on occurrence.  Defaults to \code{TRUE}}
}
}

\section{Details}{

\verb{$n} count of errors received

\verb{$errors} list of error information

\verb{$verbose} boolean that determines of errors are printed when received

\verb{$has_no_errors()} helper method to determine if there are no errors

\verb{$has_any_errors()} helper method to determine if there are any errors

\verb{$get_sub_source(loc)} helper method to display a subsection of source text given Location information

\verb{$add(rule_code, ...)} add a new error according to the \code{rule_code} provided. Remaining arguments are passed directly to \code{paste(..., sep = "")} with extra error rule information

\verb{$.format(...)} formats the error list into user friendly text. Remaining arguments are ignored

\verb{$print(...)} prints the error list by calling \code{self$format(...)}
}

\examples{
error_list <- ErrorList$new()
error_list
error_list$has_any_errors() # FALSE
error_list$has_no_errors() # TRUE

error_list$add("3.1.1", "Multiple part", " error about Scalars")
error_list
error_list$has_any_errors() # TRUE
error_list$has_no_errors() # FALSE

}
