% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_storage.R
\name{load_data}
\alias{load_data}
\title{Load Tournament Data}
\usage{
load_data(file_path, tournament = NULL)
}
\arguments{
\item{file_path}{Path to data file (.rds or .parquet)}

\item{tournament}{Optional tournament name filter (partial match)}
}
\value{
A tibble with tournament leaderboard data
}
\description{
Load tournament data from a file. Auto-detects format based on extension.
}
\examples{
\dontrun{
# Load all data
data <- load_data("golf_data.rds")

# Load and filter to Masters
masters <- load_data("golf_data.rds", tournament = "Masters")
}
}
