% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm_message.R
\name{gm_modify_message}
\alias{gm_modify_message}
\title{Modify the labels on a message}
\usage{
gm_modify_message(id, add_labels = NULL, remove_labels = NULL, user_id = "me")
}
\arguments{
\item{id}{message id to access}

\item{add_labels}{label IDs to add to the specified message}

\item{remove_labels}{label IDs to remove from the specified message}

\item{user_id}{gmail user_id to access, special value of 'me' indicates the authenticated user.}
}
\description{
Function to modify the labels on a given message by id.  Note you need to
use the label ID as arguments to this function, not the label name.
}
\examples{
\dontrun{
gm_modify_message(12345, add_labels = "label_1")
gm_modify_message(12345, remove_labels = "label_1")
# add and remove at the same time
gm_modify_message(12345, add_labels = "label_2", remove_labels = "label_1")
}
}
\references{
\url{https://developers.google.com/gmail/api/reference/rest/v1/users.messages/modify}
}
\seealso{
Other message: 
\code{\link{gm_attachment}()},
\code{\link{gm_delete_message}()},
\code{\link{gm_import_message}()},
\code{\link{gm_insert_message}()},
\code{\link{gm_message}()},
\code{\link{gm_messages}()},
\code{\link{gm_save_attachment}()},
\code{\link{gm_save_attachments}()},
\code{\link{gm_send_message}()},
\code{\link{gm_trash_message}()},
\code{\link{gm_untrash_message}()}
}
\concept{message}
