% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordiggplot.R
\name{ordiggplot}
\alias{ordiggplot}
\alias{ggscores}
\title{Create a ggplot Object}
\usage{
ordiggplot(model, axes = c(1, 2), arrow.mul, ...)

ggscores(score)
}
\arguments{
\item{model}{An ordination result object from \CRANpkg{vegan}.}

\item{axes}{Two axes to be plotted}

\item{arrow.mul}{Multiplier to arrow length. If missing, the arrow
length are adjusted to fit to other scores, but if some score
types are not displayed, the arrows may be badly scaled, and
manual adjustment can be useful.}

\item{...}{Parameters passed to underlying functions.}

\item{score}{Ordination score to be added to the plot.}
}
\value{
Returns a ggplot object.
}
\description{
Function \code{ordiggplot} sets up an ordination graph but draws no
result. You can add new graphical elements to this plot with
\verb{geom_ordi_*} function of this package, or you can use standard
\CRANpkg{ggplot2} \verb{geom_*} functions and use \code{ggscores}
as their \code{data} argument.
}
\details{
The \pkg{ggvegan} package has two contrasting approaches to draw
ordination plots. The \code{autoplot} functions (e.g. \code{\link[=autoplot.rda]{autoplot.rda()}},
\code{\link[=autoplot.cca]{autoplot.cca()}}, and \link{autoplot.metaMDS}) draw a complete plot with one
command, but the design is hard-coded in the function. However, you
can add new elements to the graph.

In contrast, function \code{ordiggplot()} only sets up an ordination
plot, and does not draw anything. It allows you to add layers to the plot
one by one with full flexibility of the \CRANpkg{ggplot2} functions.
There are some specific functions \verb{geom_ordi_*}
functions that are similar as similarly named \verb{geom_*}
functions. For these you need to give the type of ordination scores
to be added, and in addition, you can give any \verb{geom_*}
function arguments to modify the plot. Alternatively, you can use
any \pkg{ggplot2} function and in its \code{data} argument use
\code{ggscores()} function to select the data elements for the
function.

The \code{ordiggplot()} function extracts results using
\code{fortify()} functions of this package, and it accepts the
arguments of those functions. This allows setting, e.g., the
scaling of ordination axes.
}
\examples{
library("vegan")
library("ggplot2")
data(dune, dune.env, varespec, varechem)
m <- cca(dune ~ Management + A1, dune.env)

## use geom_ordi_* functions
ordiggplot(m) + geom_ordi_axis() +
  geom_ordi_point("sites") +
  geom_ordi_text("species", col = "darkblue",
                 mapping = aes(fontface = "italic")) +
  geom_ordi_label("centroids") +
  geom_ordi_arrow("biplot")

## use ggscores + standard geom_* functions
ordiggplot(m, scaling = "sites") +
  geom_point(data = ggscores("sites")) +
  geom_text(data = ggscores("species"),
            mapping = aes(fontface = "italic")) +
  geom_label(data = ggscores("centroids"), fill = "yellow") +
  geom_ordi_arrow("biplot")

## Messy arrow biplot for PCA
m <- rda(dune)
ordiggplot(m) +
  geom_ordi_axis() +
  geom_ordi_point("sites") +
  geom_ordi_arrow("species")
}
