% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.isomap.R
\name{fortify.isomap}
\alias{fortify.isomap}
\alias{tidy.isomap}
\title{Fortify isometric feature mapping results}
\usage{
\method{fortify}{isomap}(model, data = NULL, axes = NULL, what = c("sites", "network"), ...)

\method{tidy}{isomap}(x, data = NULL, axes = NULL, what = c("sites", "network"), ...)
}
\arguments{
\item{model, x}{an object of class \code{\link[vegan:isomap]{vegan::isomap()}}.}

\item{data}{data.frame; additional data to be added to the fortified object.}

\item{axes}{numeric; which axes to return. For \code{what = "network"} this must
be of length two only.}

\item{what}{character; what aspect of the results should be fortified?
\code{"sites"} returns to ordination scores from the multidimensional scaling
part of the model. \code{"network"} returns the coordinates for edges joining
points.}

\item{...}{additional arguments for other methods. Currently ignored.}
}
\value{
A data frame. For \code{what = "sites"}, the data frame contains one
variable per dimension of the multidimensional scaling embedding of the
dissimilarities. Variables are named \code{"DimX"} with \code{"X"} being an integer.
An additional variable is \code{label}, containing a label for each observation.
For \code{what = "network"}, the data frame contains four variables containing
the coordinates in the chosen MDS axes for the start and end points of the
network edges.
}
\description{
Prepares fortified versions of results from \code{\link[vegan:isomap]{vegan::isomap()}}
objects.
}
\details{
Two different objects can be created from the results of an
\code{\link[vegan:isomap]{vegan::isomap()}} object. The first is the standard scores representation
of fortified ordinations in vegan, which results in a wide data frame
where rows contain observations and column the coordinates of observations
on the MDS axes. Because ISOMAP also produces a network or sorts, the
coordinates of the edges of the network can also be returned in a tidy
format using \code{what = "network"}.
}
\examples{

library("vegan")

library("ggplot2")
data(BCI)
dis <- vegdist(BCI)
ord <- isomap(dis, k = 3)

df <- fortify(ord, data = data.frame(Richness = specnumber(BCI)))
net <- fortify(ord, what = "network", axes = 1:2)

ggplot(df, aes(x = dim1, y = dim2)) +
    geom_segment(data = net,
                 aes(x = xfrom, y = yfrom,
                     xend = xto, yend = yto),
                 colour = "grey85", size = 0.8) +
    geom_point(aes(size = Richness)) +
    coord_fixed()
}
\author{
Gavin L. Simpson
}
