% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpedigreeCore.R
\name{.addNodes}
\alias{.addNodes}
\alias{addNodes}
\title{Add Nodes to ggplot Pedigree Plot}
\usage{
.addNodes(plotObject, config, focal_fill_column = NULL, status_column = NULL)

addNodes(plotObject, config, focal_fill_column = NULL, status_column = NULL)
}
\arguments{
\item{plotObject}{A ggplot object.}

\item{config}{A list of configuration options for customizing the plot.
      See getDefaultPlotConfig for details of each option. The list can include:
\describe{
   \item{code_male}{Integer or string. Value identifying males in the sex column. (typically 0 or 1) Default: 1}
   \item{segment_spouse_color, segment_self_color}{Character. Line colors for respective connection types.}
   \item{segment_sibling_color, segment_parent_color, segment_offspring_color}{Character. Line colors for respective connection types.}
   \item{label_text_size, point_size, segment_linewidth}{Numeric. Controls text size, point size, and line thickness.}
   \item{generation_height}{Numeric. Vertical spacing multiplier between generations. Default: 1.}
   \item{shape_unknown, shape_female, shape_male, status_shape_affected}{Integers. Shape codes for plotting each group.}
   \item{sex_shape_labels}{Character vector of labels for the sex variable. (default: c("Female", "Male", "Unknown"))}
   \item{unaffected, affected}{Values indicating unaffected/affected status.}
   \item{sex_color_include}{Logical. If TRUE, uses color to differentiate sex.}
   \item{label_max_overlaps}{Maximum number of overlaps allowed in repelled labels.}
   \item{label_segment_color}{Color used for label connector lines.}
 }}

\item{focal_fill_column}{Character string specifying the column name for focal fill color.}

\item{status_column}{Character string specifying the column name for affected status. Defaults to NULL.}
}
\description{
Add Nodes to ggplot Pedigree Plot
}
\keyword{internal}
