% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quants.R
\name{quantize_mxfp4}
\alias{quantize_mxfp4}
\title{Quantize Data (MXFP4)}
\usage{
quantize_mxfp4(src_data, n_rows, n_per_row, imatrix = NULL)
}
\arguments{
\item{src_data}{Numeric vector of float values to quantize}

\item{n_rows}{Number of rows}

\item{n_per_row}{Number of elements per row}

\item{imatrix}{Optional importance matrix (numeric vector or NULL)}
}
\value{
Raw vector of quantized data
}
\description{
Quantizes float data to MXFP4 (microscaling FP4) format.
}
\seealso{
Other quantization: 
\code{\link{dequantize_row_iq2_xxs}()},
\code{\link{dequantize_row_mxfp4}()},
\code{\link{dequantize_row_q2_K}()},
\code{\link{dequantize_row_q4_0}()},
\code{\link{dequantize_row_tq1_0}()},
\code{\link{ggml_quant_block_info}()},
\code{\link{iq2xs_free_impl}()},
\code{\link{iq2xs_init_impl}()},
\code{\link{iq3xs_free_impl}()},
\code{\link{iq3xs_init_impl}()},
\code{\link{quantize_iq2_xxs}()},
\code{\link{quantize_q2_K}()},
\code{\link{quantize_q4_0}()},
\code{\link{quantize_row_iq3_xxs_ref}()},
\code{\link{quantize_row_mxfp4_ref}()},
\code{\link{quantize_row_q2_K_ref}()},
\code{\link{quantize_row_q4_0_ref}()},
\code{\link{quantize_row_tq1_0_ref}()},
\code{\link{quantize_tq1_0}()}
}
\concept{quantization}
