% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_reshape_4d}
\alias{ggml_reshape_4d}
\title{Reshape to 4D (Graph)}
\usage{
ggml_reshape_4d(ctx, a, ne0, ne1, ne2, ne3)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}

\item{ne0}{Size of dimension 0}

\item{ne1}{Size of dimension 1}

\item{ne2}{Size of dimension 2}

\item{ne3}{Size of dimension 3}
}
\value{
Reshaped tensor
}
\description{
Reshapes tensor to 4D with shape (ne0, ne1, ne2, ne3)
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 120)
ggml_set_f32(a, 1:120)
result <- ggml_reshape_4d(ctx, a, 2, 3, 4, 5)
ggml_free(ctx)
}
}
