% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_leaky_relu}
\alias{ggml_leaky_relu}
\title{Leaky ReLU Activation (Graph)}
\usage{
ggml_leaky_relu(ctx, a, negative_slope = 0.01, inplace = FALSE)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}

\item{negative_slope}{Slope for negative values (default: 0.01)}

\item{inplace}{If TRUE, operation is performed in-place (default: FALSE)}
}
\value{
Tensor representing the Leaky ReLU operation
}
\description{
Creates a graph node for Leaky ReLU activation.
LeakyReLU(x) = x if x > 0, else negative_slope * x.
Unlike standard ReLU, Leaky ReLU allows a small gradient for negative values.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(-2, -1, 0, 1, 2))
r <- ggml_leaky_relu(ctx, a, negative_slope = 0.1)
graph <- ggml_build_forward_expand(ctx, r)
ggml_graph_compute(ctx, graph)
result <- ggml_get_f32(r)  # [-0.2, -0.1, 0, 1, 2]
ggml_free(ctx)
}
}
