% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_hardsigmoid}
\alias{ggml_hardsigmoid}
\title{Hard Sigmoid Activation (Graph)}
\usage{
ggml_hardsigmoid(ctx, a)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}
}
\value{
Tensor representing the Hard Sigmoid operation
}
\description{
Creates a graph node for Hard Sigmoid activation.
HardSigmoid(x) = ReLU6(x + 3) / 6 = min(max(0, x + 3), 6) / 6.
A computationally efficient approximation of the sigmoid function.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(-4, -1, 0, 1, 4))
r <- ggml_hardsigmoid(ctx, a)
graph <- ggml_build_forward_expand(ctx, r)
ggml_graph_compute(ctx, graph)
result <- ggml_get_f32(r)  # [0, 0.333, 0.5, 0.667, 1]
ggml_free(ctx)
}
}
