% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_get_rows}
\alias{ggml_get_rows}
\title{Get Rows by Indices (Graph)}
\usage{
ggml_get_rows(ctx, a, b)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Data tensor of shape [n_embd, n_rows, ...] - the embedding table}

\item{b}{Index tensor (int32) of shape [n_indices] - which rows to extract}
}
\value{
Tensor of shape [n_embd, n_indices, ...] containing the selected rows
}
\description{
Creates a graph node that extracts rows from a tensor by index.
This is commonly used for embedding lookup in LLMs.
}
\details{
This operation is fundamental for embedding lookup in transformers:
given a vocabulary embedding matrix and token indices, it retrieves
the corresponding embedding vectors.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
# Create embedding matrix: 10 tokens, 4-dim embeddings
embeddings <- ggml_new_tensor_2d(ctx, GGML_TYPE_F32, 4, 10)
ggml_set_f32(embeddings, rnorm(40))
# Token indices to look up
indices <- ggml_new_tensor_1d(ctx, GGML_TYPE_I32, 3)
ggml_set_i32(indices, c(0L, 5L, 2L))
# Get embeddings for tokens 0, 5, 2
result <- ggml_get_rows(ctx, embeddings, indices)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
ggml_free(ctx)
}
}
