% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggml.R, R/operations.R
\name{ggml_add}
\alias{ggml_add}
\title{Add tensors}
\usage{
ggml_add(ctx, a, b)

ggml_add(ctx, a, b)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{First tensor}

\item{b}{Second tensor (same shape as a)}
}
\value{
Tensor representing the addition operation

Tensor representing the addition operation
}
\description{
Creates a graph node for element-wise addition. Must be computed using
ggml_build_forward_expand() and ggml_graph_compute().
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
b <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(1, 2, 3, 4, 5))
ggml_set_f32(b, c(5, 4, 3, 2, 1))
result <- ggml_add(ctx, a, b)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
ggml_get_f32(result)
ggml_free(ctx)
}
\donttest{
ctx <- ggml_init(1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
b <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(1, 2, 3, 4, 5))
ggml_set_f32(b, c(5, 4, 3, 2, 1))
result <- ggml_add(ctx, a, b)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
ggml_get_f32(result)
ggml_free(ctx)
}
}
