% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggiraph-themes.R
\name{theme_facets_interactive}
\alias{theme_facets_interactive}
\title{Interactive theme for ggiraph facets}
\usage{
theme_facets_interactive(
  base_theme = theme_bw(),
  interactive_text = TRUE,
  interactive_rects = TRUE,
  strip_text_color = NULL,
  strip_background_color = NULL,
  strip_text_size = NULL
)
}
\arguments{
\item{base_theme}{A theme that will will be modified}

\item{interactive_text}{A logical indicating whether text elements of strips should be interactive.}

\item{interactive_rects}{A logical indicating whether rect elements of strips should be interactive.}

\item{strip_text_color}{Color for strip text (or NULL to retain settings from \code{base_theme})}

\item{strip_background_color}{Color for strip background (or NULL to retain settings from \code{base_theme})}

\item{strip_text_size}{Size for strip text (or NULL to retain settings from \code{base_theme})}
}
\value{
A ggplot2 theme object
}
\description{
A theme that enables interactive strip text and backgrounds for faceted plots
using ggiraph. This theme ensures that facet labels can receive hover events
and tooltips.
}
