% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upset_plot.R
\name{process_upset_data}
\alias{process_upset_data}
\title{process upset data}
\usage{
process_upset_data(
  venn,
  nintersects = 30,
  order.intersect.by = "size",
  order.set.by = "name",
  specific = TRUE
)
}
\arguments{
\item{venn}{a class Venn object}

\item{nintersects}{number of intersects. If NULL, all intersections will show.}

\item{order.intersect.by}{'size', 'name', or "none"}

\item{order.set.by}{'size', 'name', or "none"}

\item{specific}{whether return ONLY specific items for a subset, default is TRUE}
}
\value{
a upsetPlotData object
}
\description{
process upset data
}
\details{
ggVennDiagram, by default, only return the specific subsets of a region.
 However, sometimes, we want to show all the overlapping items for two or more sets.
 For example: https://github.com/gaospecial/ggVennDiagram/issues/64
 Therefore, we add a 'specific' switch to this function. While 'specific = FALSE',
 the seperator will be changed from "/" to "~", and all the overlapping items
 will be returned. This feature is useful in plotting upset plot.
}
