% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vpts_coverage.R
\name{get_vpts_coverage}
\alias{get_vpts_coverage}
\title{Get VPTS file coverage from supported sources}
\usage{
get_vpts_coverage(source = c("baltrad", "uva", "ecog-04003", "rmi"), ...)
}
\arguments{
\item{source}{Source of the data. One or more of \code{"baltrad"}, \code{"uva"},
\code{"ecog-04003"} or \code{"rmi"}. If not provided, \code{"baltrad"} is used.
Alternatively \code{"all"} can be used if data from all sources should be
returned.}

\item{...}{Arguments passed on to internal functions.}
}
\value{
A \code{data.frame} or \code{tibble} with at least three columns, \code{source},
\code{radar} and \code{date} to indicate the combination for which data exists.
}
\description{
Gets the VPTS file coverage from supported sources per radar and date.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_vpts_coverage()
\dontshow{\}) # examplesIf}
}
