% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GNAbstractManager.R
\docType{class}
\name{GNAbstractManager}
\alias{GNAbstractManager}
\title{GNAbstractManager}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} with methods for communication with
the REST API of a GeoNetwork instance.
}
\description{
GNAbstractManager

GNAbstractManager
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geonetwork}
\keyword{rest}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{verbose.info}}{If package info log messages have to be printed out}

\item{\code{verbose.debug}}{If curl debug log messages have to be printed out}

\item{\code{loggerType}}{the type of logger}

\item{\code{url}}{the Base url of GeoNetwork}

\item{\code{version}}{the version of GeoNetwork. Handled as \code{GNVersion} object}

\item{\code{lang}}{the language for Geonetwork service. Default is \code{eng}}

\item{\code{basicAuth}}{if basic auth is performed}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GNAbstractManager-logger}{\code{GNAbstractManager$logger()}}
\item \href{#method-GNAbstractManager-INFO}{\code{GNAbstractManager$INFO()}}
\item \href{#method-GNAbstractManager-WARN}{\code{GNAbstractManager$WARN()}}
\item \href{#method-GNAbstractManager-ERROR}{\code{GNAbstractManager$ERROR()}}
\item \href{#method-GNAbstractManager-new}{\code{GNAbstractManager$new()}}
\item \href{#method-GNAbstractManager-getUrl}{\code{GNAbstractManager$getUrl()}}
\item \href{#method-GNAbstractManager-getLang}{\code{GNAbstractManager$getLang()}}
\item \href{#method-GNAbstractManager-login}{\code{GNAbstractManager$login()}}
\item \href{#method-GNAbstractManager-getClassName}{\code{GNAbstractManager$getClassName()}}
\item \href{#method-GNAbstractManager-clone}{\code{GNAbstractManager$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNAbstractManager-logger"></a>}}
\if{latex}{\out{\hypertarget{method-GNAbstractManager-logger}{}}}
\subsection{Method \code{logger()}}{
Provides log messages
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNAbstractManager$logger(type, text)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{type of log ("INFO", "WARN", "ERROR")}

\item{\code{text}}{the log message text}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNAbstractManager-INFO"></a>}}
\if{latex}{\out{\hypertarget{method-GNAbstractManager-INFO}{}}}
\subsection{Method \code{INFO()}}{
Provides INFO log messages
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNAbstractManager$INFO(text)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{the log message text}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNAbstractManager-WARN"></a>}}
\if{latex}{\out{\hypertarget{method-GNAbstractManager-WARN}{}}}
\subsection{Method \code{WARN()}}{
Provides WARN log messages
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNAbstractManager$WARN(text)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{the log message text}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNAbstractManager-ERROR"></a>}}
\if{latex}{\out{\hypertarget{method-GNAbstractManager-ERROR}{}}}
\subsection{Method \code{ERROR()}}{
Provides ERROR log messages
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNAbstractManager$ERROR(text)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{the log message text}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNAbstractManager-new"></a>}}
\if{latex}{\out{\hypertarget{method-GNAbstractManager-new}{}}}
\subsection{Method \code{new()}}{
This method is used to instantiate a \link{GNAbstractManager} with the \code{url} of the
   GeoNetwork and credentials to authenticate (\code{user}/\code{pwd}). By default,
   the \code{logger} argument will be set to \code{NULL} (no logger).
   
   The \code{keyring_backend} can be set to use a different backend for storing 
   the Geonetwork password/token with \pkg{keyring} (Default value is 'env').
   
   The logger can be either NULL, "INFO" (with minimum logs), or "DEBUG" 
   (for complete curl http calls logs)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNAbstractManager$new(
  url,
  user = NULL,
  pwd = NULL,
  version,
  logger = NULL,
  keyring_backend = "env"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{url}

\item{\code{user}}{user}

\item{\code{pwd}}{pwd}

\item{\code{version}}{version}

\item{\code{logger}}{logger}

\item{\code{keyring_backend}}{keyring backend. Default is 'env'}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNAbstractManager-getUrl"></a>}}
\if{latex}{\out{\hypertarget{method-GNAbstractManager-getUrl}{}}}
\subsection{Method \code{getUrl()}}{
Get URL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNAbstractManager$getUrl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNAbstractManager-getLang"></a>}}
\if{latex}{\out{\hypertarget{method-GNAbstractManager-getLang}{}}}
\subsection{Method \code{getLang()}}{
Get service language
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNAbstractManager$getLang()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNAbstractManager-login"></a>}}
\if{latex}{\out{\hypertarget{method-GNAbstractManager-login}{}}}
\subsection{Method \code{login()}}{
Log-ins. This methods (here abstract) attempts a connection to GeoNetwork API. Used internally
 by subclasses of \link{GNAbstractManager} to login Geonetwork.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNAbstractManager$login(user, pwd)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user}}{user}

\item{\code{pwd}}{pwd}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNAbstractManager-getClassName"></a>}}
\if{latex}{\out{\hypertarget{method-GNAbstractManager-getClassName}{}}}
\subsection{Method \code{getClassName()}}{
Get class name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNAbstractManager$getClassName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNAbstractManager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GNAbstractManager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNAbstractManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
