% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exal.r
\name{qexal}
\alias{qexal}
\title{Quantile Function for the exAL Distribution}
\usage{
qexal(
  p,
  p0 = 0.5,
  mu = 0,
  sigma = 1,
  gamma = 0,
  lower.tail = TRUE,
  log.p = FALSE
)
}
\arguments{
\item{p}{Numeric vector of probabilities in (0, 1).}

\item{p0}{Probability level used in the quantile parametrization. Scalar in (0, 1). Default \code{0.5}.}

\item{mu}{Location parameter (scalar). Default \code{0}.}

\item{sigma}{Scale parameter (scalar, strictly positive). Default \code{1}.}

\item{gamma}{Skewness parameter controlling asymmetry (scalar). Must be within valid bounds implied by \code{p0}. Default \code{0}.}

\item{lower.tail}{Logical scalar; if \code{TRUE} (default) return \eqn{P(X \le q)}, otherwise \eqn{P(X > q)}.}

\item{log.p}{Logical scalar; if \code{TRUE}, return log-probabilities.}
}
\value{
Numeric vector of quantiles (same length as \code{p}).
}
\description{
Vectorized over \code{p}.
}
\examples{
p <- seq(0.1, 0.9, by = 0.2)
q <- qexal(p, p0 = 0.5, mu = 0, sigma = 1, gamma = 0)
all.equal(p, pexal(q, p0 = 0.5, mu = 0, sigma = 1, gamma = 0), tol = 1e-4)

}
