% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{send_status}
\alias{send_status}
\title{Send a WhatsApp Status (story)}
\usage{
send_status(
  client,
  type = c("text", "image", "video", "document", "audio"),
  content,
  caption = NULL,
  background_color = NULL,
  font = NULL,
  all_contacts = FALSE,
  status_jid_list = NULL,
  verbose = FALSE
)
}
\arguments{
\item{client}{An \code{\link[=evo_client]{evo_client()}} object.}

\item{type}{One of \code{"text"}, \code{"image"}, \code{"video"}, \code{"document"}, \code{"audio"}.}

\item{content}{Text (for \code{type = "text"}) or URL/base64 for media.}

\item{caption}{Optional caption for media types.}

\item{background_color}{Hex colour for text status background
(e.g., \code{"#FF5733"}).}

\item{font}{Integer font id (0--14).}

\item{all_contacts}{Logical. If \code{TRUE}, sends to all contacts.}

\item{status_jid_list}{Optional character vector of specific JIDs to
receive the status.}

\item{verbose}{Logical. If \code{TRUE}, logs request/response details with
\strong{cli}.}
}
\value{
A named list with the API response. The HTTP status code is
stored in \code{attr(result, "http_status")}.
}
\description{
Posts a status (story) message visible to your contacts.
Supports text or media (image, video, document, audio) types.
}
\examples{
\dontrun{
send_status(client, type = "text", content = "Hello from R!",
            background_color = "#317873", font = 2, all_contacts = TRUE)
}
}
