% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{send_buttons}
\alias{send_buttons}
\title{Send interactive buttons}
\usage{
send_buttons(
  client,
  number,
  title,
  description,
  footer,
  buttons,
  delay = NULL,
  link_preview = NULL,
  mentions_everyone = NULL,
  verbose = FALSE
)
}
\arguments{
\item{client}{An \code{\link[=evo_client]{evo_client()}} object.}

\item{number}{Character. Recipient number with country code
(e.g., \code{"5581999990000"} or \code{"+5581999990000"}).}

\item{title}{Character. Button message title.}

\item{description}{Character. Button message description/body.}

\item{footer}{Character. Footer text.}

\item{buttons}{List of buttons. Each button should be a named list
following the API specification (see Evolution API docs).}

\item{delay}{Integer (ms). Optional presence delay before sending.
Simulates typing before the message is sent.}

\item{link_preview}{Logical. Enable URL link preview in the message.}

\item{mentions_everyone}{Logical. Mention everyone in a group.}

\item{verbose}{Logical. If \code{TRUE}, logs request/response details with
\strong{cli}.}
}
\value{
A named list with the API response. The HTTP status code is
stored in \code{attr(result, "http_status")}.
}
\description{
Sends a message with interactive buttons via Evolution API v2.
}
\note{
\strong{Baileys connector:} Interactive buttons are \strong{not supported} on
the Baileys (WhatsApp Web) connector and are likely to be discontinued.
This endpoint is fully supported only on the \strong{Cloud API} connector.
If you are on Baileys, consider using \code{\link[=send_poll]{send_poll()}} as an alternative.
}
\examples{
\dontrun{
send_buttons(client, "5581999990000",
  title = "Choose",
  description = "Pick an option:",
  footer = "Powered by R",
  buttons = list(
    list(type = "reply", title = "Option A"),
    list(type = "reply", title = "Option B")
  ))
}
}
\seealso{
\code{\link[=send_poll]{send_poll()}}
}
