## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)

## -----------------------------------------------------------------------------
# library(egnyte)
# 
# eg_auth()

## -----------------------------------------------------------------------------
# # Read a CSV file
# dat <- eg_read_csv("/Shared/Data/analysis.csv")

## -----------------------------------------------------------------------------
# # Specify column types
# dat <- eg_read_csv(
#   "/Shared/Data/analysis.csv",
#   col_types = cols(
#     id = col_integer(),
#     name = col_character(),
#     value = col_double()
#   )
# )
# 
# # Skip rows, select columns, etc.
# dat <- eg_read_csv(
#   "/Shared/Data/analysis.csv",
#   skip = 2,
#   col_select = c(id, name, value)
# )

## -----------------------------------------------------------------------------
# # Tab-delimited file (default)
# dat <- eg_read_delim("/Shared/Data/data.tsv")
# 
# # Pipe-delimited file
# dat <- eg_read_delim("/Shared/Data/data.txt", delim = "|")
# 
# # Semicolon-delimited (common in European CSVs)
# dat <- eg_read_delim("/Shared/Data/european.csv", delim = ";")

## -----------------------------------------------------------------------------
# # Read an Excel file (first sheet by default)
# dat <- eg_read_excel("/Shared/Data/workbook.xlsx")
# 
# # Read a specific sheet by name
# dat <- eg_read_excel("/Shared/Data/workbook.xlsx", sheet = "Summary")
# 
# # Read a specific sheet by position
# dat <- eg_read_excel("/Shared/Data/workbook.xlsx", sheet = 3)

## -----------------------------------------------------------------------------
# # Specify a range
# dat <- eg_read_excel(
#   "/Shared/Data/workbook.xlsx",
#   range = "B2:F100"
# )
# 
# # Skip rows
# dat <- eg_read_excel(
#   "/Shared/Data/workbook.xlsx",
#   skip = 5
# )

## -----------------------------------------------------------------------------
# # Read a SAS7BDAT file
# dat <- eg_read_sas("/Shared/Data/dataset.sas7bdat")
# 
# # Read a SAS transport file (.xpt)
# dat <- eg_read_xpt("/Shared/Data/dataset.xpt")

## -----------------------------------------------------------------------------
# # Read a Stata file
# dat <- eg_read_stata("/Shared/Data/dataset.dta")

## -----------------------------------------------------------------------------
# # Read an SPSS file
# dat <- eg_read_spss("/Shared/Data/dataset.sav")

## -----------------------------------------------------------------------------
# # Read an RDS file
# obj <- eg_read_rds("/Shared/Data/model.rds")

## -----------------------------------------------------------------------------
# # Write a data frame to CSV
# eg_write_csv(dat, "/Shared/Data/results.csv")

## -----------------------------------------------------------------------------
# # Overwrite an existing file
# eg_write_csv(dat, "/Shared/Data/results.csv", overwrite = TRUE)

## -----------------------------------------------------------------------------
# # Don't include column names
# eg_write_csv(dat, "/Shared/Data/results.csv", col_names = FALSE)
# 
# # Use a different NA representation
# eg_write_csv(dat, "/Shared/Data/results.csv", na = ".")

## -----------------------------------------------------------------------------
# # Write a tab-delimited file
# eg_write_delim(dat, "/Shared/Data/results.tsv")
# 
# # Write with a different delimiter
# eg_write_delim(dat, "/Shared/Data/results.txt", delim = "|")

## -----------------------------------------------------------------------------
# # Write a single sheet
# eg_write_excel(dat, "/Shared/Data/results.xlsx")
# 
# # Write multiple sheets by passing a named list
# eg_write_excel(
#   list(
#     "Summary" = summary_df,
#     "Details" = details_df,
#     "Raw" = raw_df
#   ),
#   "/Shared/Data/workbook.xlsx"
# )

## -----------------------------------------------------------------------------
# # Write a SAS transport file
# eg_write_xpt(dat, "/Shared/Data/results.xpt")

## -----------------------------------------------------------------------------
# # Write a Stata file
# eg_write_stata(dat, "/Shared/Data/results.dta")

## -----------------------------------------------------------------------------
# # Write an SPSS file
# eg_write_spss(dat, "/Shared/Data/results.sav")

## -----------------------------------------------------------------------------
# # Save any R object
# eg_write_rds(fitted_model, "/Shared/Data/model.rds")
# 
# # Control compression
# eg_write_rds(large_data, "/Shared/Data/data.rds", compress = "xz")

## -----------------------------------------------------------------------------
# # readr options
# dat <- eg_read_csv(
#   "/Shared/Data/data.csv",
#   col_types = "ccdd",
#   locale = locale(decimal_mark = ","),
#   na = c("", "NA", "N/A", ".")
# )
# 
# # haven options
# dat <- eg_read_sas(
#   "/Shared/Data/data.sas7bdat",
#   encoding = "latin1"
# )

## -----------------------------------------------------------------------------
# # One step - download and read
# dat <- eg_read_csv("/Shared/Data/data.csv")

## -----------------------------------------------------------------------------
# # Two steps - download, then read
# temp_file <- eg_read("/Shared/Data/data.csv")
# dat <- readr::read_csv(temp_file)
# unlink(temp_file)  # Clean up

