% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_posterior_parameters.R
\name{summarise_posterior_parameters}
\alias{summarise_posterior_parameters}
\alias{summarise_posterior_parameters.abc}
\title{Summarise posterior parameter distributions}
\usage{
summarise_posterior_parameters(data, ...)

\method{summarise_posterior_parameters}{abc}(data, ..., ci_level = 0.95)
}
\arguments{
\item{data}{An \code{abc} object containing posterior samples in
\code{adj.values} or \code{unadj.values}.}

\item{...}{Additional arguments for custom summary functions. Functions passed
as named arguments will be applied to each parameter's posterior samples.}

\item{ci_level}{Numeric; confidence interval level (default: 0.95).}
}
\value{
A data frame with summary statistics for each parameter.
}
\description{
Compute summary statistics (mean, median, confidence intervals) for posterior
parameters from ABC results.
}
\examples{
# Load ABC output from saved file
abc_file <- system.file(
  "extdata", "rdm_minimal", "abc", "abc_rejection_model.rds",
  package = "eam"
)
abc_rejection_model <- readRDS(abc_file)

# Summarise posterior distributions
summarise_posterior_parameters(abc_rejection_model)

# Custom confidence interval level
summarise_posterior_parameters(abc_rejection_model, ci_level = 0.90)

}
\seealso{
\code{\link{summarise_posterior_parameters.abc}}
}
