% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddbs_affine.R
\name{ddbs_scale}
\alias{ddbs_scale}
\title{Scale geometries by X and Y factors}
\usage{
ddbs_scale(
  x,
  x_scale = 1,
  y_scale = 1,
  by_feature = FALSE,
  conn = NULL,
  name = NULL,
  crs = NULL,
  crs_column = "crs_duckspatial",
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{x}{An \code{sf} spatial object. Alternatively, it can be a string with the
name of a table with geometry column within the DuckDB database \code{conn}.
Data is returned from this object.}

\item{x_scale}{numeric value specifying the scaling factor in the X direction (default = 1)}

\item{y_scale}{numeric value specifying the scaling factor in the Y direction (default = 1)}

\item{by_feature}{Logical. If \code{TRUE}, the geometric operation is applied
separately to each geometry. If \code{FALSE} (default), the geometric
operation is applied to the data as a whole.}

\item{conn}{A connection object to a DuckDB database. If \code{NULL}, the function
runs on a temporary DuckDB database.}

\item{name}{A character string of length one specifying the name of the table,
or a character string of length two specifying the schema and table
names. If \code{NULL} (the default), the function returns the result as an
\code{sf} object}

\item{crs}{The coordinates reference system of the data. Specify if the data
doesn't have a \code{crs_column}, and you know the CRS.}

\item{crs_column}{a character string of length one specifying the column
storing the CRS (created automatically by \code{\link{ddbs_write_vector}}).
Set to \code{NULL} if absent.}

\item{overwrite}{Boolean. whether to overwrite the existing table if it exists. Defaults
to \code{FALSE}. This argument is ignored when \code{name} is \code{NULL}.}

\item{quiet}{A logical value. If \code{TRUE}, suppresses any informational messages.
Defaults to \code{FALSE}.}
}
\value{
an \code{sf} object or \code{TRUE} (invisibly) for table creation
}
\description{
Scales geometries around the centroid of the geometry. Returns the result as
an \code{sf} object or creates a new table in the database.
}
\examples{
\dontrun{
## load packages
library(duckspatial)
library(sf)

# create a duckdb database in memory (with spatial extension)
conn <- ddbs_create_conn(dbdir = "memory")

## read data
countries_sf <- read_sf(system.file("spatial/countries.geojson", package = "duckspatial")) |>
  filter(CNTR_ID \%in\% c("PT", "ES", "FR", "IT"))

## store in duckdb
ddbs_write_vector(conn, countries_sf, "countries")

## scale to 150\% in both directions
ddbs_scale(conn = conn, "countries", x_scale = 1.5, y_scale = 1.5)

## scale to 200\% horizontally, 50\% vertically
ddbs_scale(conn = conn, "countries", x_scale = 2, y_scale = 0.5)

## scale all features together (default)
ddbs_scale(countries_sf, x_scale = 1.5, y_scale = 1.5, by_feature = FALSE)

## scale each feature independently
ddbs_scale(countries_sf, x_scale = 1.5, y_scale = 1.5, by_feature = TRUE)

}
}
