% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets_doc_for_CRAN.R
\docType{data}
\name{Ponerinae_cat_3lvl_data_old_calib}
\alias{Ponerinae_cat_3lvl_data_old_calib}
\title{Data summarizing the evolution of fake habitat data in Ponerinae ants using a 3-level factor as categorical trait}
\format{
A list with 5 elements.
}
\usage{
data(Ponerinae_cat_3lvl_data_old_calib)
}
\description{
A list containing fake habitat data of Ponerinae ants mapped on the phylogeny,
modeled with \link[geiger:fitDiscrete]{geiger::fitDiscrete}. This object was obtained with \code{\link[=prepare_trait_data]{prepare_trait_data()}}.
This is NOT real biological/ecological data. They were designed for illustrative purposes only.
The phylogeny used is also NOT a properly time-calibrated phylogeny. It uses an ill-designed old calibration for illustrative purposes.
}
\details{
A list of five objects containing information on the evolution of fake habitat data in Ponerinae ants.
This object was obtained with \code{\link[=prepare_trait_data]{prepare_trait_data()}}.
\itemize{
\item \verb{$densityMaps} List of three objects of class \verb{"densityMap} that contains a phylogenetic tree and associated mapping of probability
to harbor a given state along branches. The list contains one \verb{"densityMap} per state found in the \code{tip_data} (i.e., "arboreal", "subterranean", and "terricolous").
\item \verb{$trait_data_type} Character string. Record the type of trait data. Here: "categorical".
\item \verb{$ace} Numerical matrix that record the posterior probabilities of ancestral states (characters) estimates (ACE) at internal nodes.
Rows are internal nodes. Columns are states (i.e., "large" and "small"). Values are posterior probabilities of each state per node.
\item \verb{$best_model_fit} List that provides the output of the best fitting model (Here: ARD model).
\item \verb{$model_selection_df} Data.frame that summarizes model comparisons used to select the best fitting model.
}
}
\seealso{
\code{\link[=prepare_trait_data]{prepare_trait_data()}}
}
\keyword{datasets}
