% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modresults.r
\name{modresults}
\alias{modresults}
\title{Creates an object having the main fitting statistics from a
regression model.}
\usage{
modresults(mod = mod, print.output = FALSE, conf.lev = 0.95, eng = TRUE)
}
\arguments{
\item{mod}{An object containing the fitted model by using
the \code{lm()} function.}

\item{print.output}{A logical option for printing, or displaying, the
saved outputs at the console. The default is set to TRUE, meanwhile if
\code{print.output}=FALSE, nothing is printed.}

\item{conf.lev}{A numeric value (between 0.0001 and 0.9999) representing
the confidence level to be used for some components of the output.
The default value is 0.95.}

\item{eng}{The language to be used in the output. English
is the default, meanwhile if \code{eng}=FALSE, Spanish is used.}
}
\value{
This function returns a list having several components
of a fitted regression model.
}
\description{
Function to save the main statistics results froma fitted regression model.
}
\details{
The resulting object contains several outputs derived
from a regression model.
}
\examples{

library(datana)
df <- datana::maple
head(df)
datana::descstat(df[,c("total","dbh")])
graphics::plot(total ~ dbh, data=df)
slr.m1<-stats::lm(total ~ dbh, data=df)
## Example 1 -- store all the results to an object
out<-modresults(mod = slr.m1)
out$modsumm
out$sigma.e
out$press
out$tcal.coef
out$vp.tcal.coef
## Example 2
modresults(mod = slr.m1, print.output=TRUE)
}
\references{
Salas-Eljatib, C. 2021. Análisis de datos con el programa
estadístico R: una introducción aplicada. Ediciones Universidad
Mayor, Santiago, Chile. 170 p. \url{https://eljatib.com/rlibro}
}
\author{
A somehow related version of this function was first created
by Prof. Timothy Gregoire (Yale University), but the current
version is due to Christian Salas-Eljatib.
}
