% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssh_exec_stdout.R
\name{ssh_exec_stdout}
\alias{ssh_exec_stdout}
\title{Execute and Capture Standard Output}
\usage{
ssh_exec_stdout(command, session = NULL, ...)
}
\arguments{
\item{command}{command or script to execute.}

\item{session}{optional object of class \code{ssh_connect}.}

\item{\dots}{passed to \code{\link[ssh]{ssh_exec_internal}}.}
}
\value{
A \code{"character"} vector containing the standard output.
}
\description{
Call \code{ssh_exec_internal} and convert the standard output to characters.
}
\details{
The default value of \code{session = NULL} looks for a \code{session} object
in the user workspace. This allows the user to run Condor functions without
explicitly specifying the \code{session}.
}
\examples{
\dontrun{
session <- ssh_connect("servername")

ssh_exec_wait(session, "ls")             # returns 0
ssh_exec_internal(session, "ls")$stdout  # returns a raw vector
ssh_exec_stdout("ls")                    # returns directory names
}

}
\seealso{
\code{\link[ssh]{ssh_exec_wait}} runs a command or script and shows the
standard output in the R console, while returning the exit status.

\code{\link[ssh]{ssh_exec_internal}} runs a command or script and buffers the
standard output into a raw vector.

\code{\link{condor-package}} gives an overview of the package.
}
\author{
Arni Magnusson.
}
