% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.mle_numerical}
\alias{plot.mle_numerical}
\title{Plot Optimization Convergence}
\usage{
\method{plot}{mle_numerical}(x, which = c("loglike", "gradient"), main = NULL, ...)
}
\arguments{
\item{x}{An mle_numerical result object with trace_data}

\item{which}{Character vector specifying which plots to show:
"loglike" (log-likelihood), "gradient" (gradient norm), "path" (2D parameter path)}

\item{main}{Optional title}

\item{...}{Additional arguments passed to plot}
}
\value{
Invisibly returns the trace data
}
\description{
Visualizes the optimization trajectory from an MLE result with tracing enabled.
Shows log-likelihood progression, gradient norm decay, and optionally the
parameter path (for 2D problems).
}
\details{
This function requires that the solver was run with tracing enabled via
\code{mle_trace()}. Without trace data, the function will warn and return
invisibly.

The "path" plot is only shown for 2D parameter problems.
}
\examples{
\donttest{
# Enable tracing when solving
problem <- mle_problem(
  loglike = function(theta) -sum((theta - c(3, 2))^2),
  constraint = mle_constraint(support = function(theta) TRUE)
)
trace_cfg <- mle_trace(values = TRUE, gradients = TRUE, path = TRUE)
result <- gradient_ascent(max_iter = 50)(problem, c(0, 0), trace = trace_cfg)

# Plot convergence diagnostics
plot(result)
}

}
