% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance_dendrogram.R
\name{balance_dendrogram}
\alias{balance_dendrogram}
\title{Compositional Balance Dendrogram}
\usage{
balance_dendrogram(X, B, group = NULL)
}
\arguments{
\item{X}{A numeric matrix or data frame representing the compositional data.
Rows are observations and columns are components (must be strictly positive).}

\item{B}{A numeric matrix representing the balance basis (e.g., an isometric log-ratio (ilr) balance matrix).}

\item{group}{Show boxplot by groups}
}
\value{
A '\code{ggplot2}' object representing the balance dendrogram.
}
\description{
Plots a balance dendrogram based on a compositional data set and a corresponding balance matrix.
This visualization helps interpret the structure of balances in compositional data analysis.
}
\details{
The dendrogram shows the hierarchical structure of balances derived from the balance matrix \code{B}.
Each internal node corresponds to a balance, and the height or color may reflect the variance explained or other statistics.
}
\examples{
# Simulated compositional data and balances
X = matrix(runif(50, 1, 10), ncol = 5)
colnames(X) = LETTERS[1:5]
B = pb_basis(X, method = 'exact')
balance_dendrogram(X, B)

}
