% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{prior}
\alias{prior}
\title{Specify Prior Distributions}
\usage{
prior(prior, class = "b", coef = "")
}
\arguments{
\item{prior}{A distribution object created by \code{\link[=normal]{normal()}}, \code{\link[=gamma]{gamma()}},
\code{\link[=student_t]{student_t()}}, or \code{\link[=cauchy]{cauchy()}}.}

\item{class}{The parameter class. Valid classes are:
\itemize{
\item \code{"b"}: Regression coefficients (beta)
\item \code{"Intercept"}: Cutpoints/thresholds (flexible)
\item \code{"c1"}: First cutpoint (equidistant)
\item \code{"d"}: Threshold interval (equidistant)
\item \code{"cpos"}: Positive cutpoints (symmetric)
\item \code{"df"}: Degrees of freedom (tlink)
\item \code{"lambda_ao"}: Lambda parameter (aranda_ordaz)
\item \code{"lambda_lg"}: Lambda parameter (log_gamma)
\item \code{"xi"}: Xi parameter (gev)
\item \code{"r"}: R parameter (sp)
\item \code{"theta1"}, \code{"theta2"}: Theta parameters (aep)
}}

\item{coef}{Optional coefficient name (for future extension).}
}
\value{
An object of class \code{"clm_prior_spec"} representing the prior specification.
}
\description{
Specify prior distributions for model parameters using distribution functions.
}
\examples{
# Specify a normal prior for regression coefficients
prior(normal(0, 2.5), class = "b")

# Specify a gamma prior for degrees of freedom
prior(gamma(2, 0.1), class = "df")

# Combine multiple priors
c(
  prior(normal(0, 2.5), class = "b"),
  prior(normal(0, 10), class = "Intercept")
)
}
\seealso{
\code{\link[=normal]{normal()}}, \code{\link[=gamma]{gamma()}}, \code{\link[=student_t]{student_t()}}, \code{\link[=cauchy]{cauchy()}}, \code{\link[=clm_prior]{clm_prior()}}
}
