% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_pkgs}
\alias{check_pkgs}
\title{Check packages}
\usage{
check_pkgs(
  package,
  n = 2L,
  output = tempfile(paste(utils::packageName(), Sys.Date(), sep = "-")),
  lib.loc = .libPaths(),
  repos = getOption("repos"),
  restore = TRUE,
  ...
)
}
\arguments{
\item{package}{A path to either package, directory with packages or name
of the package (details)}

\item{n}{\code{integer} value indicating maximum number of subprocesses that can
be simultaneously spawned when executing tasks.}

\item{output}{\code{character} value specifying path where the output should be
stored.}

\item{lib.loc}{\code{character} vector with libraries allowed to be used when
checking packages, defaults to entire \code{\link[=.libPaths]{.libPaths()}}.}

\item{repos}{\code{character} vector of repositories which will be used when
generating task graph and later pulling dependencies.}

\item{restore}{\code{logical} indicating whether output directory should be
unlinked before running checks. If \code{FALSE}, an attempt will me made to
restore previous progress from the same \code{output}}

\item{...}{Additional arguments passed to \code{\link[=run]{run()}}}
}
\value{
\code{\link[=checker]{checker()}} R6 class storing all the details
regarding checks that run. Can be combined with
\code{\link{results}} and \code{\link[=summary]{summary()}} methods to generate results.
}
\description{
Runs classical \verb{R CMD check} for the given source package. It
first identifies and installs, in parallel, all dependencies required
to check the package. Then, it runs \verb{R CMD check} for each specified package.
}
\seealso{
Other checks: 
\code{\link{STATUS}},
\code{\link{check_rev_deps}()},
\code{\link{checker}},
\code{\link{new_checker}()}
}
\concept{checks}
